
SET LOCK_TIMEOUT 12000;

DELETE FROM [SmartAttributes];
DELETE FROM [SmartAttributeTypes];
DELETE FROM [SmartDriveMap];
DELETE FROM [SmartAttributeDescriptions];
DELETE FROM [SmartDriveIssues];
DELETE FROM [SmartServerDriveHistory];

INSERT INTO [SmartServerDriveHistory] ([TransactionID], [Timestamp], [Status]) VALUES (130, 40614.891659375, 0);

INSERT INTO [SmartAttributeTypes] ([TypeID], [Flags], [HealthWeight], [HealthLimit], [MathFunction], [DescriptionID], [Threshold], [ThresholdOperator]) VALUES (1, 0, 0, 0, 2, 12, -1, 4);
INSERT INTO [SmartAttributeTypes] ([TypeID], [Flags], [HealthWeight], [HealthLimit], [MathFunction], [DescriptionID], [Threshold], [ThresholdOperator]) VALUES (2, 0, 0, 0, 7, 8, -1, 2);
INSERT INTO [SmartAttributeTypes] ([TypeID], [Flags], [HealthWeight], [HealthLimit], [MathFunction], [DescriptionID], [Threshold], [ThresholdOperator]) VALUES (3, 0, 0, 0, 1, 8, -1, 2);
INSERT INTO [SmartAttributeTypes] ([TypeID], [Flags], [HealthWeight], [HealthLimit], [MathFunction], [DescriptionID], [Threshold], [ThresholdOperator]) VALUES (4, 0, 0, 0, 6, 8, -1, 2);
INSERT INTO [SmartAttributeTypes] ([TypeID], [Flags], [HealthWeight], [HealthLimit], [MathFunction], [DescriptionID], [Threshold], [ThresholdOperator]) VALUES (5, 0, 0, 0, 8, 8, -1, 2);

INSERT INTO [SmartDriveMap] ([ID], [Manufacturer], [Family], [NameRegex], [FirmwareRegex], [SerialRegex], [MinOperatingTemperature], [MaxOperatingTemperature], [TemperatureAttribute], [TemperatureThreshold], [TemperatureGoodLimit], [TemperatureWarningLimit], [TemperaturePoorLimit], [TemperatureGoodBars], [TemperatureWarningBars], [TemperaturePoorBars], [TemperatureAlertThreshold]) VALUES (3, N'Maxtor', N'^DiamondMax Plus 9', N'Maxtor 6Y((060|080|120|160)L0|(060|080|120|160|200|250)P0|(060|080|120|160|200|250)M0)', N'', N'', 0, 60, -1, -1, 50, 59, 68, 3, 3, 3, -1);
INSERT INTO [SmartDriveMap] ([ID], [Manufacturer], [Family], [NameRegex], [FirmwareRegex], [SerialRegex], [MinOperatingTemperature], [MaxOperatingTemperature], [TemperatureAttribute], [TemperatureThreshold], [TemperatureGoodLimit], [TemperatureWarningLimit], [TemperaturePoorLimit], [TemperatureGoodBars], [TemperatureWarningBars], [TemperaturePoorBars], [TemperatureAlertThreshold]) VALUES (5, N'Maxtor', N'', N'^Maxtor .*', N'', N'', 0, 60, -1, -1, 50, 59, 68, 3, 3, 3, -1);
INSERT INTO [SmartDriveMap] ([ID], [Manufacturer], [Family], [NameRegex], [FirmwareRegex], [SerialRegex], [MinOperatingTemperature], [MaxOperatingTemperature], [TemperatureAttribute], [TemperatureThreshold], [TemperatureGoodLimit], [TemperatureWarningLimit], [TemperaturePoorLimit], [TemperatureGoodBars], [TemperatureWarningBars], [TemperaturePoorBars], [TemperatureAlertThreshold]) VALUES (6, N'Seagate', N'', N'^ST.*', N'', N'', 0, 60, -1, -1, 50, 59, 68, 3, 3, 3, -1);
INSERT INTO [SmartDriveMap] ([ID], [Manufacturer], [Family], [NameRegex], [FirmwareRegex], [SerialRegex], [MinOperatingTemperature], [MaxOperatingTemperature], [TemperatureAttribute], [TemperatureThreshold], [TemperatureGoodLimit], [TemperatureWarningLimit], [TemperaturePoorLimit], [TemperatureGoodBars], [TemperatureWarningBars], [TemperaturePoorBars], [TemperatureAlertThreshold]) VALUES (7, N'Fujitsu', N'', N'^FUJITSU .*', N'', N'', 0, 60, -1, -1, 50, 59, 68, 3, 3, 3, -1);
INSERT INTO [SmartDriveMap] ([ID], [Manufacturer], [Family], [NameRegex], [FirmwareRegex], [SerialRegex], [MinOperatingTemperature], [MaxOperatingTemperature], [TemperatureAttribute], [TemperatureThreshold], [TemperatureGoodLimit], [TemperatureWarningLimit], [TemperaturePoorLimit], [TemperatureGoodBars], [TemperatureWarningBars], [TemperaturePoorBars], [TemperatureAlertThreshold]) VALUES (8, N'Western Digital', N'', N'^WDC WD.*', N'', N'', 0, 60, -1, -1, 50, 59, 68, 3, 3, 3, -1);
INSERT INTO [SmartDriveMap] ([ID], [Manufacturer], [Family], [NameRegex], [FirmwareRegex], [SerialRegex], [MinOperatingTemperature], [MaxOperatingTemperature], [TemperatureAttribute], [TemperatureThreshold], [TemperatureGoodLimit], [TemperatureWarningLimit], [TemperaturePoorLimit], [TemperatureGoodBars], [TemperatureWarningBars], [TemperaturePoorBars], [TemperatureAlertThreshold]) VALUES (9, N'Samsung', N'', N'^SAMSUNG (HD|HM)', N'', N'', 0, 60, -1, -1, 50, 59, 68, 3, 3, 3, -1);
INSERT INTO [SmartDriveMap] ([ID], [Manufacturer], [Family], [NameRegex], [FirmwareRegex], [SerialRegex], [MinOperatingTemperature], [MaxOperatingTemperature], [TemperatureAttribute], [TemperatureThreshold], [TemperatureGoodLimit], [TemperatureWarningLimit], [TemperaturePoorLimit], [TemperatureGoodBars], [TemperatureWarningBars], [TemperaturePoorBars], [TemperatureAlertThreshold]) VALUES (10, N'Samsung', N'', N'^SAMSUNG .*', N'', N'', 0, 60, -1, -1, 50, 59, 68, 3, 3, 3, -1);
INSERT INTO [SmartDriveMap] ([ID], [Manufacturer], [Family], [NameRegex], [FirmwareRegex], [SerialRegex], [MinOperatingTemperature], [MaxOperatingTemperature], [TemperatureAttribute], [TemperatureThreshold], [TemperatureGoodLimit], [TemperatureWarningLimit], [TemperaturePoorLimit], [TemperatureGoodBars], [TemperatureWarningBars], [TemperaturePoorBars], [TemperatureAlertThreshold]) VALUES (11, N'Hitachi', N'', N'(Hitachi )?HD.*', N'', N'', 0, 60, -1, -1, 50, 59, 68, 3, 3, 3, -1);
INSERT INTO [SmartDriveMap] ([ID], [Manufacturer], [Family], [NameRegex], [FirmwareRegex], [SerialRegex], [MinOperatingTemperature], [MaxOperatingTemperature], [TemperatureAttribute], [TemperatureThreshold], [TemperatureGoodLimit], [TemperatureWarningLimit], [TemperaturePoorLimit], [TemperatureGoodBars], [TemperatureWarningBars], [TemperaturePoorBars], [TemperatureAlertThreshold]) VALUES (12, N'Western Digital', N'', N'^WDC AC.*', N'', N'', 0, 60, -1, -1, 50, 59, 68, 3, 3, 3, -1);
INSERT INTO [SmartDriveMap] ([ID], [Manufacturer], [Family], [NameRegex], [FirmwareRegex], [SerialRegex], [MinOperatingTemperature], [MaxOperatingTemperature], [TemperatureAttribute], [TemperatureThreshold], [TemperatureGoodLimit], [TemperatureWarningLimit], [TemperaturePoorLimit], [TemperatureGoodBars], [TemperatureWarningBars], [TemperaturePoorBars], [TemperatureAlertThreshold]) VALUES (13, N'Toshiba', N'', N'^TOS(HIBA)? .*', N'', N'', 0, 60, -1, -1, 50, 59, 68, 3, 3, 3, -1);
INSERT INTO [SmartDriveMap] ([ID], [Manufacturer], [Family], [NameRegex], [FirmwareRegex], [SerialRegex], [MinOperatingTemperature], [MaxOperatingTemperature], [TemperatureAttribute], [TemperatureThreshold], [TemperatureGoodLimit], [TemperatureWarningLimit], [TemperaturePoorLimit], [TemperatureGoodBars], [TemperatureWarningBars], [TemperaturePoorBars], [TemperatureAlertThreshold]) VALUES (14, N'Western Digital', N'Scorpio Blue', N'^WDC WD(10|800|1200|1600|2500|3200|4000|5000|6400|7500)(AAKS|TPVT|BPVT|BEVT|BEVS|BEVE)', N'', N'', 0, 60, -1, -1, 50, 59, 68, 3, 3, 3, -1);
INSERT INTO [SmartDriveMap] ([ID], [Manufacturer], [Family], [NameRegex], [FirmwareRegex], [SerialRegex], [MinOperatingTemperature], [MaxOperatingTemperature], [TemperatureAttribute], [TemperatureThreshold], [TemperatureGoodLimit], [TemperatureWarningLimit], [TemperaturePoorLimit], [TemperatureGoodBars], [TemperatureWarningBars], [TemperaturePoorBars], [TemperatureAlertThreshold]) VALUES (15, N'Samsung', N'Spinpoint', N'^SAMSUNG .*(HD204UI|HD155U).*', N'', N'', 0, 60, -1, -1, 50, 59, 68, 3, 3, 3, -1);

INSERT INTO [SmartAttributes] ([DriveID], [AttributeID], [Type]) VALUES (3, 9, 1);
INSERT INTO [SmartAttributes] ([DriveID], [AttributeID], [Type]) VALUES (7, 194, 2);
INSERT INTO [SmartAttributes] ([DriveID], [AttributeID], [Type]) VALUES (9, 194, 2);
INSERT INTO [SmartAttributes] ([DriveID], [AttributeID], [Type]) VALUES (11, 194, 2);
INSERT INTO [SmartAttributes] ([DriveID], [AttributeID], [Type]) VALUES (13, 194, 2);
INSERT INTO [SmartAttributes] ([DriveID], [AttributeID], [Type]) VALUES (14, 194, 2);

INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (1, 1033, N'Raw Read Error Rate', N'This attribute stores data read retries rate of hardware read errors that occurred when reading data from a disk surface. Different vendors will have different raw value structure which is often not meaningful as a decimal number.  Lower values indicate that there is a problem with either disk surface or read/write heads.');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (2, 1033, N'Spin Up Time', N'This attribute''s raw value indicates average time to spin up the drive spindle (from zero RPM to fully operational [milliseconds]).');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (3, 1033, N'Start/Stop Count', N'This attribute''s raw value is a count of hard disk spindle start/stop cycles.');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (4, 1033, N'Reallocated Sector Count', N'This attribute''s value indicates exact count of bad sectors that have been found and remapped (reallocated). If the sector became bad for some reason then the drive replaces it with a spare sector from a special spare area. The value of 100 means that no sectors were remapped.');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (5, 1033, N'Seek Error Rate', N'This attribute value shows average rate of seek errors. Seek errors arise when there is a partial failure in the mechanical positioning system.  The failure might be due to damage to a servo, or thermal widening of the hard disk. Lower values shows that there is a problem with head positioning.');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (6, 1033, N'Spin Retry Count', N'This attribute shows the total count of number of retries of drive spindle spin start attempts to reach the fully operational speed (under the condition that the first attempt was unsuccessful). Higher value indicates a sign of problems in the hard disk mechanical subsystem.');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (7, 1033, N'Device Power Cycle Count', N'This attribute shows the total count of full disk power on/off cycles.');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (8, 1033, N'Temperature', N'This attribute shows a drive''s current internal temperature If the drive contains a dedicated thermal sensor.');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (9, 1033, N'Hardware ECC errors recovered', N'This attribute indicates the count of ECC-corrected errors. Different vendors have different structures as the raw value for this attribute. Decrease in the value of this parameter may indicate electromechanical problems of the disk.');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (10, 1033, N'Current Pending Sector Count', N'This attribute shows the count of pending or unstable sectors (waiting to be remapped because of read errors). If the sector issues an error during read or, the drive marks it as pending for a certain time before replacing this error sector with a spare one.');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (11, 1033, N'Uncorrectable Sector Count', N'This attribute indicates the total number of uncorrectable errors when reading/writing a sector. Increase in the value of this attribute indicates that there are evident defects of the disk surface and/or there are problems in the hard disk drive mechanical subsystem.');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (12, 1033, N'Power-On Hours Count', N'This attribute shows a total count of hours (or minutes, or seconds, depending on manufacturer) in power-on state. ');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (13, 1033, N'Command Timeout', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (14, 1033, N'Disk Shift', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (15, 1033, N'End To End Error', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (16, 1033, N'Free Fall Protection', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (17, 1033, N'G-Sense Error Rate', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (18, 1033, N'G-Sense Error Rate', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (19, 1033, N'GMR Head Amplitude', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (20, 1033, N'Head Flying Height', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (21, 1033, N'Head Flying Hours', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (22, 1033, N'Head Stability', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (23, 1033, N'High Fly Write', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (24, 1033, N'Induced Op Vibration Detection', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (25, 1033, N'Load Friction', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (26, 1033, N'Load-in Time', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (27, 1033, N'Load/Unload Cycle Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (28, 1033, N'Load/Unload Retry Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (29, 1033, N'Loaded Hours', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (30, 1033, N'Multi-Zone Error Rate', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (31, 1033, N'Offline Seek Performance', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (32, 1033, N'Power-Off Retract Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (33, 1033, N'Power-Off Retract Cycle', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (34, 1033, N'Read Channel Margin', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (35, 1033, N'Read Error Retry Rate', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (36, 1033, N'Reallocation Events Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (37, 1033, N'Recalibration Retries', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (38, 1033, N'Reported Uncorrectable Errors', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (39, 1033, N'Run Out Cancel', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (40, 1033, N'Sata Downshift Error Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (41, 1033, N'Seek Time Performance', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (42, 1033, N'Shock During Write', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (43, 1033, N'Soft Ecc Correction', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (44, 1033, N'Soft Read Error Rate', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (45, 1033, N'Spin Buzz', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (46, 1033, N'Spin High Current', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (47, 1033, N'TA Counter Detected', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (48, 1033, N'TA Counter Increased', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (49, 1033, N'Temperature Difference from 100', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (50, 1033, N'Thermal Asperity Rate', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (51, 1033, N'Throughput Performance', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (52, 1033, N'Torque Amplification Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (53, 1033, N'Total LBAs Read', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (54, 1033, N'Total LBAs Written', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (55, 1033, N'UltraDMA CRC Error Rate', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (56, 1033, N'Vibration During Write', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (57, 1033, N'Airflow Temperature', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (58, 1033, N'Average FHC', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (59, 1033, N'Data Address Mark Errors', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (60, 1033, N'Drive Calibration Retry Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (61, 1033, N'Drive Power Cycle Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (62, 1033, N'Drive Temperature', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (63, 1033, N'ECC Errors', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (64, 1033, N'End-to-end error count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (65, 1033, N'Erase Fail Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (66, 1033, N'Erase/Program cycles', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (67, 1033, N'Flying Height', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (68, 1033, N'Hardware ECC Recovered', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (69, 1033, N'HDA Temperature', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (70, 1033, N'High Fly Writes', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (71, 1033, N'Induced Op-Vibration Detection', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (72, 1033, N'Maximum FHC', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (73, 1033, N'Multi Zone Error Rate', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (74, 1033, N'Off-line Scan Uncorrectable Sector Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (75, 1033, N'Power-On Hours Count/Power-On Time Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (76, 1033, N'Program Fail Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (77, 1033, N'Reallocation Event Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (78, 1033, N'Reported Uncorrectable Error', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (79, 1033, N'Reserved Block Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (80, 1033, N'Shock Sense Error Rate', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (81, 1033, N'Spin Up Retry Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (82, 1033, N'TA Increase Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (83, 1033, N'Total LBA Read', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (84, 1033, N'Total LBA Write', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (85, 1033, N'Translation Table Rebuild', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (86, 1033, N'Ultra DMA CRC Error Rate', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (87, 1033, N'Unexpected Power Loss', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (88, 1033, N'Wear Leveling Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (89, 1033, N'Write Error Rate/Count', N'');
INSERT INTO [SmartAttributeDescriptions] ([DescriptionID], [Language], [Name], [Description]) VALUES (90, 1033, N'Unknown Attribute', N'');


INSERT INTO [SmartDriveIssues] ([IssueID], [DriveID], [Language], [Description], [LongDescription], [KBArticleURL], [ManufacturerURL], [DisableSMART]) VALUES (1, 15, 1033, N'Samsung has identified a firmware issue that can lead to loss of data during writes when the IDENTIFY DEVICE command is sent to the drive. Due to this issue, use of SMART data in PerfectDisk for this drive has been disabled.', N'', N'', N'http://www.samsung.com/global/business/hdd/faqView.do?b2b_bbs_msg_id=386', 1);

